<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

require_role('admin');

try {
  $totalProducts = (int)db()->query("SELECT COUNT(*) FROM products")->fetchColumn();
  $totalShops = (int)db()->query("SELECT COUNT(*) FROM shops")->fetchColumn();
  $completedOrders = (int)db()->query("SELECT COUNT(*) FROM order_intents WHERE status='completed'")->fetchColumn();

  json_response([
    'ok' => true,
    'stats' => [
      'total_products' => $totalProducts,
      'total_shops' => $totalShops,
      'completed_orders' => $completedOrders
    ]
  ]);
} catch (Throwable $e) {
  json_response([
    'ok' => false,
    'error' => 'STATS_FAILED',
    'message' => APP_DEBUG ? $e->getMessage() : 'Unable to load dashboard stats'
  ], 500);
}
