<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

require_role('admin');

$ownerId = (int)($_GET['owner_id'] ?? 0);
if ($ownerId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'owner_id required'], 422);
}

$ownerStmt = db()->prepare("
  SELECT id, full_name, phone, email, is_active, must_change_password, created_at
  FROM users
  WHERE id = ? AND role = 'owner'
  LIMIT 1
");
$ownerStmt->execute([$ownerId]);
$owner = $ownerStmt->fetch();
if (!$owner) {
  json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Owner not found'], 404);
}

$shopsStmt = db()->prepare("
  SELECT id, name, is_verified, is_suspended, created_at
  FROM shops
  WHERE owner_id = ?
  ORDER BY id DESC
");
$shopsStmt->execute([$ownerId]);
$shops = $shopsStmt->fetchAll();

json_response(['ok' => true, 'owner' => $owner, 'shops' => $shops]);
