<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

require_role('admin');

$body = get_request_json();
$ownerId = (int)($body['owner_id'] ?? 0);
if ($ownerId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'owner_id required'], 422);
}

$tempPassword = 'Owner@' . substr(bin2hex(random_bytes(4)), 0, 6);
$hash = password_hash($tempPassword, PASSWORD_DEFAULT);

$stmt = db()->prepare("
  UPDATE users
  SET password_hash = ?, must_change_password = 1
  WHERE id = ? AND role = 'owner'
");
$stmt->execute([$hash, $ownerId]);

if ($stmt->rowCount() === 0) {
  json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Owner not found'], 404);
}

json_response(['ok' => true, 'temp_password' => $tempPassword]);
