<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

require_role('admin');

$shopId = (int)($_GET['shop_id'] ?? 0);
if ($shopId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'shop_id required'], 422);
}

$shopStmt = db()->prepare("
  SELECT id, owner_id, name, description, whatsapp_phone, address, is_verified, is_suspended, created_at
  FROM shops
  WHERE id = ?
  LIMIT 1
");
$shopStmt->execute([$shopId]);
$shop = $shopStmt->fetch();
if (!$shop) {
  json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);
}

$ownerStmt = db()->prepare("
  SELECT id, full_name, phone, email, is_active
  FROM users
  WHERE id = ? AND role = 'owner'
  LIMIT 1
");
$ownerStmt->execute([(int)$shop['owner_id']]);
$owner = $ownerStmt->fetch();

json_response(['ok' => true, 'shop' => $shop, 'owner' => $owner ?: null]);
