<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

require_role('admin');

$body = get_request_json();
$shopId = (int)($body['shop_id'] ?? 0);
$isSuspended = (int)($body['is_suspended'] ?? 1);

if ($shopId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'shop_id is required'], 422);
}

$stmt = db()->prepare("UPDATE shops SET is_suspended = ?, updated_at = ? WHERE id = ?");
$stmt->execute([$isSuspended ? 1 : 0, now_utc(), $shopId]);

json_response(['ok' => true]);
