<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$user = require_login();

$body = get_request_json();
$old = (string)($body['old_password'] ?? '');
$new = (string)($body['new_password'] ?? '');

if ($old === '' || $new === '') {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'old_password and new_password are required'], 422);
}

if (strlen($new) < 6) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'new_password must be at least 6 characters'], 422);
}

$stmt = db()->prepare("SELECT password_hash FROM users WHERE id = ? LIMIT 1");
$stmt->execute([(int)$user['id']]);
$row = $stmt->fetch();

if (!$row || !password_verify($old, (string)$row['password_hash'])) {
  json_response(['ok' => false, 'error' => 'INVALID_CREDENTIALS'], 401);
}

$newHash = password_hash($new, PASSWORD_DEFAULT);

$upd = db()->prepare("UPDATE users SET password_hash = ?, must_change_password = 0, updated_at = ? WHERE id = ?");
$upd->execute([$newHash, now_utc(), (int)$user['id']]);

if (($user['role'] ?? '') === 'owner') {
  $shopUpd = db()->prepare("
    UPDATE shops
    SET is_verified = 1, is_suspended = 0, updated_at = ?
    WHERE owner_id = ?
  ");
  $shopUpd->execute([now_utc(), (int)$user['id']]);
}

json_response(['ok' => true]);
