<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();
$body = get_request_json();

$orderId = (int)($body['order_intent_id'] ?? 0);
if ($orderId <= 0) json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'order_intent_id required'], 422);

$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);

$shopId = (int)$shop['id'];

$check = db()->prepare("SELECT id, status FROM order_intents WHERE id=? AND shop_id=? LIMIT 1");
$check->execute([$orderId, $shopId]);
$row = $check->fetch();
if (!$row) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Order not found'], 404);

if (($row['status'] ?? '') === 'completed') {
  json_response(['ok' => true, 'message' => 'Already completed']);
}

$upd = db()->prepare("UPDATE order_intents SET status='completed', completed_at=? WHERE id=? AND shop_id=?");
$upd->execute([now_utc(), $orderId, $shopId]);

json_response(['ok' => true]);
