<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

// must be owner + must have changed password
$u = require_owner();

$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);
$shopId = (int)$shop['id'];

// Multipart form fields
$name = safe_string($_POST['name'] ?? '', 180);
$description = safe_string($_POST['description'] ?? '', 2000);
$price = (float)($_POST['price'] ?? 0);

if ($name === '' || $price <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'name and price are required'], 422);
}

// Optional image
$imageUrl = save_uploaded_image(
  'image',
  __DIR__ . '/../../uploads/products',
  '/shop-system/uploads/products'
);

$stmt = db()->prepare("
  INSERT INTO products (shop_id, name, description, price, image_path, is_active, created_at)
  VALUES (?, ?, ?, ?, ?, 1, ?)
");
$stmt->execute([
  $shopId,
  $name,
  $description !== '' ? $description : null,
  $price,
  $imageUrl,
  now_utc()
]);

json_response(['ok' => true, 'product_id' => (int)db()->lastInsertId()]);
