<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();
$body = get_request_json();

$orderId = (int)($body['order_intent_id'] ?? 0);
if ($orderId <= 0) json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'order_intent_id required'], 422);

// Owner shop
$shopStmt = db()->prepare("SELECT id, name FROM shops WHERE owner_id=? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);
$shopId = (int)$shop['id'];

// Order must belong to this shop and be completed
$oStmt = db()->prepare("SELECT id, status FROM order_intents WHERE id=? AND shop_id=? LIMIT 1");
$oStmt->execute([$orderId, $shopId]);
$order = $oStmt->fetch();
if (!$order) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Order not found'], 404);
if (($order['status'] ?? '') !== 'completed') json_response(['ok' => false, 'error' => 'NOT_COMPLETED', 'message' => 'Order must be completed first'], 400);

// Prevent duplicate review
$chk = db()->prepare("SELECT id FROM reviews WHERE order_intent_id=? LIMIT 1");
$chk->execute([$orderId]);
if ($chk->fetch()) json_response(['ok' => false, 'error' => 'ALREADY_REVIEWED'], 400);

// Create token (raw) + store hash
$rawToken = bin2hex(random_bytes(16)); // 32 chars
$hash = hash('sha256', $rawToken);

$expires = gmdate('Y-m-d H:i:s', time() + 7 * 86400);

$ins = db()->prepare("
  INSERT INTO review_tokens (token_hash, order_intent_id, shop_id, expires_at, used_at, created_at)
  VALUES (?, ?, ?, ?, NULL, ?)
");
$ins->execute([$hash, $orderId, $shopId, $expires, now_utc()]);

$reviewUrl = "/shop-system/app/review.html?token=" . $rawToken;

json_response([
  'ok' => true,
  'order_intent_id' => $orderId,
  'expires_at' => $expires,
  'review_url' => $reviewUrl
]);
