<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$owner = require_owner();

$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$owner['id']]);
$shop = $shopStmt->fetch();

if (!$shop) {
  json_response([
    'ok' => true,
    'stats' => [
      'total_orders' => 0,
      'completed_orders' => 0,
      'total_reviews' => 0
    ]
  ]);
}

$shopId = (int)$shop['id'];

$ordersStmt = db()->prepare("SELECT COUNT(*) FROM order_intents WHERE shop_id = ?");
$ordersStmt->execute([$shopId]);
$totalOrders = (int)$ordersStmt->fetchColumn();

$completedStmt = db()->prepare("SELECT COUNT(*) FROM order_intents WHERE shop_id = ? AND status = 'completed'");
$completedStmt->execute([$shopId]);
$completedOrders = (int)$completedStmt->fetchColumn();

$reviewsStmt = db()->prepare("SELECT COUNT(*) FROM reviews WHERE shop_id = ?");
$reviewsStmt->execute([$shopId]);
$totalReviews = (int)$reviewsStmt->fetchColumn();

json_response([
  'ok' => true,
  'stats' => [
    'total_orders' => $totalOrders,
    'completed_orders' => $completedOrders,
    'total_reviews' => $totalReviews
  ]
]);
