<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();

$body = get_request_json();
$productId = (int)($body['product_id'] ?? 0);
if ($productId <= 0) json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'product_id required'], 422);

$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);
$shopId = (int)$shop['id'];

$stmt = db()->prepare("DELETE FROM products WHERE id = ? AND shop_id = ?");
$stmt->execute([$productId, $shopId]);

json_response(['ok' => true]);
