<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();

$shopStmt = db()->prepare("SELECT id, name FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);

$shopId = (int)$shop['id'];

$ordersStmt = db()->prepare("
  SELECT id, order_code, customer_phone, referral_phone, status, created_at, completed_at
  FROM order_intents
  WHERE shop_id = ?
  ORDER BY id DESC
  LIMIT 100
");
$ordersStmt->execute([$shopId]);
$orders = $ordersStmt->fetchAll();

if (!$orders) json_response(['ok' => true, 'shop' => $shop, 'orders' => []]);

$orderIds = array_map(fn($o) => (int)$o['id'], $orders);
$placeholders = implode(',', array_fill(0, count($orderIds), '?'));

$itemsStmt = db()->prepare("
  SELECT order_intent_id, product_id, product_name, unit_price, qty
  FROM order_items
  WHERE order_intent_id IN ($placeholders)
  ORDER BY id ASC
");
$itemsStmt->execute($orderIds);
$items = $itemsStmt->fetchAll();

// group items by order_intent_id
$byOrder = [];
foreach ($items as $it) {
  $oid = (int)$it['order_intent_id'];
  if (!isset($byOrder[$oid])) $byOrder[$oid] = [];
  $byOrder[$oid][] = $it;
}

foreach ($orders as &$o) {
  $oid = (int)$o['id'];
  $o['items'] = $byOrder[$oid] ?? [];
}
unset($o);

json_response(['ok' => true, 'shop' => $shop, 'orders' => $orders]);
