<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();


$shopStmt = db()->prepare("SELECT id FROM shops WHERE owner_id = ? LIMIT 1");
$shopStmt->execute([(int)$u['id']]);
$shop = $shopStmt->fetch();
if (!$shop) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found'], 404);

$shopId = (int)$shop['id'];

$stmt = db()->prepare("SELECT * FROM products WHERE shop_id = ? ORDER BY id DESC");
$stmt->execute([$shopId]);

json_response(['ok' => true, 'products' => $stmt->fetchAll()]);
