<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../auth.php';

$u = require_owner();


$stmt = db()->prepare("SELECT * FROM shops WHERE owner_id = ? LIMIT 1");
$stmt->execute([(int)$u['id']]);
$shop = $stmt->fetch();

if (!$shop) {
  json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Shop not found for this owner'], 404);
}

json_response(['ok' => true, 'shop' => $shop]);
