<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';

$q = trim((string)($_GET['q'] ?? ''));
$limit = (int)($_GET['limit'] ?? 30);
if ($limit <= 0) $limit = 30;
if ($limit > 100) $limit = 100;

if ($q !== '') {
  $stmt = db()->prepare("
    SELECT p.id, p.shop_id, p.name, p.description, p.price, p.image_path, p.created_at,
           s.name AS shop_name, s.whatsapp_phone
    FROM products p
    JOIN shops s ON s.id = p.shop_id
    WHERE p.is_active = 1
      AND s.is_verified = 1 AND s.is_suspended = 0
      AND p.name LIKE ?
    ORDER BY p.id DESC
    LIMIT $limit
  ");
  $stmt->execute(['%' . $q . '%']);
  json_response(['ok' => true, 'products' => $stmt->fetchAll(), 'q' => $q]);
}

$stmt = db()->query("
  SELECT p.id, p.shop_id, p.name, p.description, p.price, p.image_path, p.created_at,
         s.name AS shop_name, s.whatsapp_phone
  FROM products p
  JOIN shops s ON s.id = p.shop_id
  WHERE p.is_active = 1
    AND s.is_verified = 1 AND s.is_suspended = 0
  ORDER BY p.id DESC
  LIMIT $limit
");

json_response(['ok' => true, 'products' => $stmt->fetchAll()]);
