<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';

$stmt = db()->query("
  SELECT s.*,
       rs.avg_rating, rs.review_count
FROM shops s
LEFT JOIN (
  SELECT shop_id, AVG(rating) AS avg_rating, COUNT(*) AS review_count
  FROM reviews
  GROUP BY shop_id
) rs ON rs.shop_id = s.id
WHERE s.is_verified=1 AND s.is_suspended=0
ORDER BY s.id DESC
");

json_response(['ok' => true, 'shops' => $stmt->fetchAll()]);
