<?php
declare(strict_types=1);

require_once __DIR__ . '/../utils.php';
require_once __DIR__ . '/../db.php';

$productId = (int)($_GET['product_id'] ?? 0);
if ($productId <= 0) {
  json_response(['ok' => false, 'error' => 'VALIDATION', 'message' => 'product_id is required'], 422);
}

$stmt = db()->prepare("
  SELECT
    p.id, p.shop_id, p.name, p.description, p.price, p.image_path, p.is_active, p.created_at, p.updated_at,
    s.name AS shop_name, s.description AS shop_description, s.whatsapp_phone, s.logo_path, s.address,
    s.is_verified, s.is_suspended
  FROM products p
  JOIN shops s ON s.id = p.shop_id
  WHERE p.id = ?
    AND p.is_active = 1
    AND s.is_verified = 1 AND s.is_suspended = 0
  LIMIT 1
");
$stmt->execute([$productId]);
$row = $stmt->fetch();

if (!$row) json_response(['ok' => false, 'error' => 'NOT_FOUND', 'message' => 'Product not found'], 404);

json_response(['ok' => true, 'product' => $row]);
