import { API_BASE } from "./config.js";

const TOKEN_KEY = "daura_token";
const USER_KEY = "daura_user";
const LOGIN_URL = "/shop-system/app/login.html";

export function getToken() {
  return localStorage.getItem(TOKEN_KEY);
}

export function getUser() {
  const raw = localStorage.getItem(USER_KEY);
  try { return raw ? JSON.parse(raw) : null; } catch { return null; }
}

export function setUser(user) {
  if (!user) return;
  localStorage.setItem(USER_KEY, JSON.stringify(user));
}

export function setSession({ token, user }) {
  localStorage.setItem(TOKEN_KEY, token);
  localStorage.setItem(USER_KEY, JSON.stringify(user));
}

export function clearSession() {
  localStorage.removeItem(TOKEN_KEY);
  localStorage.removeItem(USER_KEY);
}

export async function login(loginValue, password) {
  const res = await fetch(`${API_BASE}/auth/login`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ login: loginValue, password })
  });
  const data = await res.json();
  if (!data.ok) throw new Error(data.message || data.error || "Login failed");
  setSession({ token: data.token, user: data.user });
  return data;
}

export async function logout() {
  const token = getToken();
  // best effort revoke
  await fetch(`${API_BASE}/auth/logout`, {
    method: "POST",
    headers: token ? { Authorization: `Bearer ${token}` } : {}
  }).catch(() => {});
  clearSession();
}

export function authHeaders() {
  const token = getToken();
  return token ? { Authorization: `Bearer ${token}` } : {};
}

export function requireLogin() {
  const token = getToken();
  const user = getUser();
  if (!token || !user) {
    window.location.href = LOGIN_URL;
    return null;
  }
  return user;
}

export function requireRole(role) {
  const user = requireLogin();
  if (!user) return null;
  if ((user.role || "") !== role) {
    window.location.href = LOGIN_URL;
    return null;
  }
  return user;
}
