import { getToken, getUser, login } from "./auth.js";

const form = document.getElementById("login-form");
const message = document.getElementById("login-message");

function showMessage(text, isError = true) {
  if (!message) return;
  message.textContent = text;
  message.style.display = "block";
  message.style.background = isError ? "#fff1f0" : "#f0fff6";
  message.style.borderColor = isError ? "rgba(159, 77, 47, 0.3)" : "rgba(47, 93, 80, 0.3)";
}

function redirectForRole(role) {
  if (role === "admin") {
    window.location.href = "/shop-system/app/admin.html";
  } else if (role === "owner") {
    window.location.href = "/shop-system/app/owner.html";
  } else {
    window.location.href = "/shop-system/app/index.html";
  }
}

const existingToken = getToken();
const existingUser = getUser();
if (existingToken && existingUser && existingUser.role) {
  redirectForRole(existingUser.role);
}

form?.addEventListener("submit", async (event) => {
  event.preventDefault();
  message.style.display = "none";

  const formData = new FormData(form);
  const loginValue = String(formData.get("login") || "").trim();
  const password = String(formData.get("password") || "");

  if (!loginValue || !password) {
    showMessage("Login and password are required.");
    return;
  }

  try {
    const data = await login(loginValue, password);
    redirectForRole(data.user?.role);
  } catch (err) {
    showMessage(err?.message || "Login failed.");
  }
});
